--**************************************************************************
-- VOXCO(c) 2013
--
-- Voxco Project Database Schema documentation
--
-- this documentation use the storedprocedure VX_DBDoc found 
-- in VX_DBDoc_SP_AND_Usage.sql
-- to commit entries in the database.  use it to validate your  changes 
-- to this document
--
-- REF VX_DBDoc_SP_AND_Usage.sql
--**************************************************************************


--Use Voxco_Project_nnnn;


--:------------------------------------------------------------------------
--: Document Voxco_Project_nnnn Stored Procedures Description
--:------------------------------------------------------------------------
-- OPTIONAL FOR NOW!!!
exec VX_DBDoc  'user.procedure','dbo.VX_sp_FillCaseBuffer', 'This procedure fills the BufferNew table with cases eligible for dialing. It is used by both IntWeb and ServNo as a fast source of cases to be dialed. All extraction are logged in table dbo.BufferTrace.'
exec VX_DBDoc  'user.procedure','dbo.sp_New', 'Deprecated. Use VX_sp_FillCaseBuffer instead. This procedure redirectes the call to VX_sp_FillCaseBuffer.'

--:------------------------------------------------------------------------
--: Respondent table details
--:------------------------------------------------------------------------ 
-- TABLE
exec VX_DBDoc 'user.table','dbo.Respondent','Contains all cases for a given survey';
-- COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Respondent.resrespondent','Case id';
exec VX_DBDoc 'user.table.column','dbo.Respondent.reslanguage','Language id (LANG question)';
exec VX_DBDoc 'user.table.column','dbo.Respondent.restimezone','Time zone id (TZONE question)';
exec VX_DBDoc 'user.table.column','dbo.Respondent.rescallbackdate','Callback date';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resintervcall','Interviewer the case is assigned to';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resnextintervcall','Next interviewer who will receive the case, when it will be released by current interviewer';
exec VX_DBDoc 'user.table.column','dbo.Respondent.restimeslot','Time slot the case is assigned to';
exec VX_DBDoc 'user.table.column','dbo.Respondent.rescallcount','Number of calls';
exec VX_DBDoc 'user.table.column','dbo.Respondent.reslastcalldate','Date when the case was last called';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resversion','(not used)';
exec VX_DBDoc 'user.table.column','dbo.Respondent.respriority','The priority assigned to the case';
exec VX_DBDoc 'user.table.column','dbo.Respondent.rescompleted','1 if the respondent has completed the survey';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resconfidphone','1 if the respondents phone number must not be displayed';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resseed','Respondent sorting within the sample';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resphone','The telephone number of the respondent';
exec VX_DBDoc 'user.table.column','dbo.Respondent.rescoderesult','The respondent''s last interruption code';
exec VX_DBDoc 'user.table.column','dbo.Respondent.reswaveno','Callback wave the respondent is currently at';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resblocked','1 if the case belongs to a closed stratum';
exec VX_DBDoc 'user.table.column','dbo.Respondent.rescomppredictive','1 if the case has been selected by the servnoserver module';
exec VX_DBDoc 'user.table.column','dbo.Respondent.rescall','1 if the case has been called or is currently on the line, or has been selected by the servnoserver module';
exec VX_DBDoc 'user.table.column','dbo.Respondent.resmonitored','The monitored flag, indicates if the respondent has been monitored'
exec VX_DBDoc 'user.table.column','dbo.Respondent.respreviouscalldate','The date and time the respondent was called before reslastcalldate';
exec VX_DBDoc 'user.table.column','dbo.Respondent.reswaveimportno','Wave number responsible for the case''s importation';
exec VX_DBDoc 'user.table.column','dbo.Respondent.ResLastCompQuest','The last completed question index of the questionnaire';
exec VX_DBDoc 'user.table.column','dbo.Respondent.projectId','The Id of the project';
exec VX_DBDoc 'user.table.column','dbo.Respondent.collectMode','The last collect mode of the case';
exec VX_DBDoc 'user.table.column','dbo.Respondent.modifiedBy','UserId. Who modified the case';
exec VX_DBDoc 'user.table.column','dbo.Respondent.modified','Date & Time Modification of the case';
exec VX_DBDoc 'user.table.column','dbo.Respondent.panelistId','The panelistId of the respondent, this is the main link to the Panel System';
exec VX_DBDoc 'user.table.column','dbo.Respondent.Location','In CAPI mode, this field tells us where this case is OnCapiClient or OnServer';
exec VX_DBDoc 'user.table.column','dbo.Respondent.ResActive','Is the case active. an inactive case cannot be chosen to complete a survey';
exec VX_DBDoc 'user.table.column','dbo.Respondent.DialingMode','Dialing mode restriction. 0 (Default) the case has no restriction; 3 (Preview) the case can not be called by automtique dialer';
exec VX_DBDoc 'user.table.column','dbo.Respondent.RestrictionOverride','Specifies that the TimeSlot or Closed stratum restrictions have been lifted (See Callback rules) for this case and can thus be called back at any time.';
exec VX_DBDoc 'user.table.column','dbo.Respondent.IntLevel','Specifies the last Case Result level encountered for the case. See Int or S_RES question documentation.';
exec VX_DBDoc 'user.table.column','dbo.Respondent.ManualDialing','Make a discrimination (or filter) to use with TCPA Manual dialers. It will be use by VX_sp_FillCaseBuffer store procedure';
--CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Respondent.PK_Respondent','Primary key is the ResRespondent';
exec VX_DBDoc 'User.Table.Constraint','dbo.Respondent.DF_Respondent_DialingMode','Defines a Default value of 0';
exec VX_DBDoc 'User.Table.Constraint','dbo.Respondent.DF_Respondent_IntLevel','Defines a Default value of 0';
exec VX_DBDoc 'User.Table.Constraint','dbo.Respondent.DF_Respondent_ResActive','';
exec VX_DBDoc 'User.Table.Constraint','dbo.Respondent.DF_Respondent_RestrictionOverride','';
--TRIGGERS
--exec VX_DBDoc 'User.Table.Trigger', 'dbo.Respondent.AtriggerName', 'this is a trigger description'


--:------------------------------------------------------------------------
--: Response Table Details
--:------------------------------------------------------------------------
-- TABLE
exec VX_DBDoc 'user.table','dbo.Response','For each respondent, contains all its answers';
-- COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Response.RpsRespondent','The Case Id ';
exec VX_DBDoc 'user.table.column','dbo.Response.RpsQuestion','The question alias';
exec VX_DBDoc 'user.table.column','dbo.Response.RpsMatrix','The roster row index : Default Value = 1. (Ex. 12000250000400217 => nested row 12-25-4-217)';
exec VX_DBDoc 'user.table.column','dbo.Response.RpsMention','The Answer mention index : Default Value = 1';
exec VX_DBDoc 'user.table.column','dbo.Response.RpsContent','The answer';
exec VX_DBDoc 'user.table.column','dbo.Response.RpsOpened','The open-ended answer';
exec VX_DBDoc 'user.table.column','dbo.Response.RpsType','Response type';
exec VX_DBDoc 'user.table.column','dbo.Response.projectId','The project id';
exec VX_DBDoc 'user.table.column','dbo.Response.collectMode','The collect mode of the answer';
exec VX_DBDoc 'user.table.column','dbo.Response.modifiedBy','UserId. Who modified the case';
exec VX_DBDoc 'user.table.column','dbo.Response.modified','Date & Time modification of the case';
exec VX_DBDoc 'user.table.column','dbo.Response.Source','the last source to write the response';
exec VX_DBDoc 'user.table.column','dbo.Response.CallId','if part of an interview, identify the callId as defined in historic table';
--CONSTRAINTS
--DF__Response__RpsMat__20C1E124  default value = 1 
--DF__Response__RpsMen__21B6055D  default value = 1 
--FK__Response__RpsRes__145C0A3F
--TRIGGERS
exec VX_DBDoc 'User.Table.Trigger', 'dbo.Response.VX_TR_ResponseModifLog_Insert', 'Trigger used for the audit of the table Dbo.Response'
exec VX_DBDoc 'User.Table.Trigger', 'dbo.Response.VX_TR_ResponseModifLog_Update', 'Trigger used for the audit of the table Dbo.Response'
exec VX_DBDoc 'User.Table.Trigger', 'dbo.Historic.VX_TR_HistoricResponse_Insert', 'Trigger used for the audit of the table Dbo.Response based on the Hostoric Table'


--:------------------------------------------------------------------------
--: Historic Table Details 
--:------------------------------------------------------------------------
--TABLE 
exec VX_DBDoc 'user.table','dbo.Historic','Contains all calls made to a given respondent';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Historic.HisRespondent','Case Id';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisCallNumber','Call id for the respondent';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisInterviewer','Interviewers initials or username or Id';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisResult','Call Result / Interruption code';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisCallDate','Date and time of the call';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisTimeSlot','Time slot the call belongs to';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisCallDuration','Call duration in seconds';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisDataType','not used';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisStartQuestion','First answered question';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisEndQuestion','Last answered question';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisMonitoring','not used';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisDialerLine','not used';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisWait','Wait time in seconds';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisPause','Pause time in seconds';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisFileReference','not used';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisPreviousCallDate','previous call date and time';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisLifeState','Life State';
exec VX_DBDoc 'user.table.column','dbo.Historic.projectId','Project id';
exec VX_DBDoc 'user.table.column','dbo.Historic.collectMode','Collect mode of the call';
exec VX_DBDoc 'user.table.column','dbo.Historic.HisPhone','Phone number used for the call';
exec VX_DBDoc 'user.table.column','dbo.Historic.DialingMode','Dialing mode';
exec VX_DBDoc 'user.table.column','dbo.Historic.LevelChanged','True if the Case Result Level changed during this call/contact. See INT or S_RES question documentation.';
exec VX_DBDoc 'user.table.column','dbo.Historic.Notes','Any call notes taken during this call/contact. See call note question documentation.';
exec VX_DBDoc 'user.table.column','dbo.Historic.RuleId','RuleId from table Rules for NextCallBack calculation if apply (nullable)';
exec VX_DBDoc 'user.table.column','dbo.Historic.ExtRuleId','RuleId from table ExtendedRules for NextCallBack calculation if apply(nullable)';
exec VX_DBDoc 'user.table.column','dbo.Historic.NextCallBack','Callback datetime calculated for the next call if apply (nullable)';

--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Historic.PK_Historic','PK  on 	[HisRespondent] ASC, [HisCallNumber] ASC';
--exec VX_DBDoc 'User.Table.Constraint','dbo.Historic.FK__Historic__HisRes__0EA330E9','FK on dbo.Respondent.ResRespondent';
exec VX_DBDoc 'User.Table.Constraint','dbo.Historic.DF_Historic_DialingMode','Dialing mode Default value = 0 ';
exec VX_DBDoc 'User.Table.Constraint','dbo.Historic.DF_Historic_LevelChanged','Level changed Default value = 0 ';




--:------------------------------------------------------------------------
--: Quota table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Quota','Contains strata definition';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Quota.QtStratum','Sequence number of the stratum in the strata table';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtCriterion','The stratum definition';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtLabel','Stratum Label';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtQuota','Stratum goal';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtSchedule','Stratum Schedule  Ref: dbo.Schedule.SchNumber';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtGroup','Group of interviewers the stratum is assigned to';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtWeight','Stratum weight';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtUnused','Unused cases in the given stratum';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtOnLine','On-line respondents in the given stratum';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtFrequence','Completed surveys in the given stratum';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtPriority','not used';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtRelative','not used';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtPeriodic','not used';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtStatus','Stratum status: 0 open, 1 half-open, 2 closed';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtStatusTemp','half-open stratum status: 0 open, 2 closed';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtLastUpDate','date and time the stratum was last modified';
exec VX_DBDoc 'user.table.column','dbo.Quota.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.Quota.modifiedBy','UserId. Who modified the strata/quota definition';
exec VX_DBDoc 'user.table.column','dbo.Quota.modified','Date & Time modification of the strata/quota definition';
exec VX_DBDoc 'user.table.column','dbo.Quota.QtQuotaId','primary Key, the stratum Id';
exec VX_DBDoc 'user.table.column','dbo.Quota.RoleId','The role Id, Ref: to dbo.Role';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Quota.PK_Quota','Quota PK  on [QtQuotaId] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.Quota.FK_Quota_Role','FK on dbo.Role.Id and dbo.Quota.RoleId';
--TRIGGERS
exec VX_DBDoc 'User.Table.Trigger', 'dbo.Quota.TRUPDATE_QUOTA', 'A trigger that resets dbo.bufferNew upon changes in stratum order'





--:------------------------------------------------------------------------
--: ImportedFields table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.ImportedFields','Contains the destination of each imported field along with importation parameters';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFNumber','Imported Field index';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFQuestion','Question alias or system variable';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFRecord','Line number for multiline importations';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFPosition','Position within a line';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFWidth','Data length';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFType','field type (code or label)';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFSkipPst','1 if the skip if present option is selected';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFSkipAbst','1 if the skip if absent option is selected';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFFieldIsQuest','1 if the ifquestion contains a question alias';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.IFFieldName','Field name, if any';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.modifiedBy','UserId. Who modified the fields definition';
exec VX_DBDoc 'user.table.column','dbo.ImportedFields.modified','Date & Time modification of the fields definition';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.ImportedFields.PK_ImportedFields','PK on IFNumber ASC';



--:------------------------------------------------------------------------
--: ImportHistory table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.ImportHistory','Contains all importation waves';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHNumber','importation wave index';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHDateTime','importation date and time';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHFileName','importation file name';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHStartQuest','importation lowest case id';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHEndQuest','importation highest case id';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHStartNumber','number of cases before the importation';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.IHEndNumber','number of cases after the importation';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.ImportHistory.modifiedBy','UserId. Who modified the record';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.ImportHistory.PK_ImportHistory','PK on [IHNumber] ASC';





--:------------------------------------------------------------------------
--: ImportedFields table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Installation','Contains all survey options';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Installation.INSSECTION','Section label of the option';
exec VX_DBDoc 'user.table.column','dbo.Installation.INSIDENT','Identifier label of the option';
exec VX_DBDoc 'user.table.column','dbo.Installation.INSVALUE','Value of the option';
exec VX_DBDoc 'user.table.column','dbo.Installation.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.Installation.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.Installation.modified','Date & Time modification of the record'
exec VX_DBDoc 'user.table.column','dbo.Installation.InsDateTimeValue','Date & Time Value of the option'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Installation.PK_Installation','PK on [INSSECTION] ASC and [INSIDENT] ASC';




--:------------------------------------------------------------------------
--: Interviewer table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Interviewer','Contains all interviewers';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Interviewer.IntNumber','interviewer index';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.IntInitiale','interviewers initials';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.IntName','interviewers name';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.SessionCompleted','monitoring sessions completed for the interviewer';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.SessionInProgress','monitoring sessions in progress for the given interviewer';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.SessionToComplete','monitoring sessions to complete for the interviewer';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.QuestionMonitored','questions monitored for the interviewer';
exec VX_DBDoc 'user.table.column','dbo.Interviewer.QuestionToMonitor','questions to monitor for the interviewer';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Interviewer.PK_Interviewer','PK on [IntNumber] ASC';



--:------------------------------------------------------------------------
--: Note table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Note','Contains all notes for a given respondent and interviewer, taken at a given time';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Note.NotRespondent','Respondent id';
exec VX_DBDoc 'user.table.column','dbo.Note.NotDateTime','Note date and time';
exec VX_DBDoc 'user.table.column','dbo.Note.NotInterv','interviewers initials';
exec VX_DBDoc 'user.table.column','dbo.Note.NotQuestion','question alias';
exec VX_DBDoc 'user.table.column','dbo.Note.NotMatrix','roster/matrix index';
exec VX_DBDoc 'user.table.column','dbo.Note.NotNote','The note text';
exec VX_DBDoc 'user.table.column','dbo.Note.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.Note.collectMode','The  collect mode of the case';
exec VX_DBDoc 'user.table.column','dbo.Note.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.Note.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Interviewer.PK_Interviewer','PK on [IntNumber] ASC';



--:------------------------------------------------------------------------
--: Rules table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Rules','Contains all callback rules. See Callback rules documentation';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Rules.RulNumber','Rule index obsolete field replace with field Id';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulResult','interruption code for the rule';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulCount','callback wave index';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulConsecutive','1 if the consecutive option is turned on';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulCallback','1 if a callback is assigned by the rule';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulInterviewer','interviewer the callback is assigned to';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulDelay','callback delay';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulUnit','callback unit (minutes, hours, days, weeks, months) applying to the rule delay';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulPriority','priority value';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulPriorityType','type of priority (absolute or relative)';
exec VX_DBDoc 'user.table.column','dbo.Rules.RulWaveInc','1 if the callback wave is incremented after applying the rule';
exec VX_DBDoc 'user.table.column','dbo.Rules.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.Rules.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.Rules.modified','Date & Time modification of the record'
exec VX_DBDoc 'user.table.column','dbo.Rules.SynchResult','Capi Synchronization Result';
exec VX_DBDoc 'user.table.column','dbo.Rules.DialingMode','Dialing mode';
exec VX_DBDoc 'user.table.column','dbo.Rules.RestrictionOverride','';
exec VX_DBDoc 'user.table.column','dbo.Rules.Deleted','For trace information';
exec VX_DBDoc 'user.table.column','dbo.Rules.Id','Rules index replacing [RulNumber] as Primary key (identity)';
exec VX_DBDoc 'user.table.column','dbo.Rules.UploadToA4S','Add rule to Acuity4 for Acuit4 modules';



--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Rules.PK_Rules','PK on [Id] ASC';
--exec VX_DBDoc 'User.Table.Constraint','dbo.Rules.DF__Rules__SynchResu__7E37BEF6','Default value for SynchResult = 0 ';
exec VX_DBDoc 'User.Table.Constraint','dbo.Rules.DF_Rules_RestrictionOverride','Default value for RestrictionOverride = 0 ';


--:------------------------------------------------------------------------
--: Schedule table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Schedule','Contains all quota schedules';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Schedule.SchNumber','Schedule index';
exec VX_DBDoc 'user.table.column','dbo.Schedule.SchLabel','Schedule label';
exec VX_DBDoc 'user.table.column','dbo.Schedule.SchAction','Schedule action (open or close stratum)';
exec VX_DBDoc 'user.table.column','dbo.Schedule.SchWeekDay','Weekday the schedule applies to';
exec VX_DBDoc 'user.table.column','dbo.Schedule.Schtime','time the schedule is applied at';
exec VX_DBDoc 'user.table.column','dbo.Schedule.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.Schedule.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.Schedule.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Schedule.PK_Schedule','PK on [SchNumber] ASC, SchLabel] ASC, [SchAction] ASC, [SchWeekDay] ASC, 	[Schtime] ASC';



--:------------------------------------------------------------------------
--: Shift table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Shift','Contains all callback shifts, See Callback rules documentation on  Shifts';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Shift.ShiShift','shift id';
exec VX_DBDoc 'user.table.column','dbo.Shift.ShiWeekDay','weekday the shift applies to';
exec VX_DBDoc 'user.table.column','dbo.Shift.shiStarttime','starting time for the shift';
exec VX_DBDoc 'user.table.column','dbo.Shift.ShiEndTime','ending time for the shift';
exec VX_DBDoc 'user.table.column','dbo.Shift.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.Shift.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.Shift.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Shift.PK_Shift','PK on [ShiShift] ASC';


--:------------------------------------------------------------------------
--: Stratum table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Stratum','Contains all the strata each case belongs to';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Stratum.StrRespondent','Case id';
exec VX_DBDoc 'user.table.column','dbo.Stratum.StrStratum','Stratum index';
exec VX_DBDoc 'user.table.column','dbo.Stratum.StrQuotaId','Quota Id';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Stratum.PK_Stratum','PK on [StrQuotaId] ASC,[StrRespondent] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.Stratum.FK__StratumAndRespondent','FK on dbo.Respondent.resRespondent';
exec VX_DBDoc 'User.Table.Constraint','dbo.Stratum.FK_StratumAndQuota','FK on dbo.Quota.QtQuotaId';



--:------------------------------------------------------------------------
--: Timeslot table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.TimeSlot','Contains all call time slots, See Callback rules documentation on TimeSlot.';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TslNumber','time slot index';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TslWeekDay','weekday the time slot applies to';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TslStartTime','starting time for the time slot';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TslEndTime','ending time for the time slot';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TslTimeSlot',' time slot id';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.modified','Date & Time modification of the record'
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.MaxCounter','Maximum number of call attempts to be done in the current timeslot. ';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.ResetOnLevelChange','Specifies if the respondent call counter for the timeslot is reset on case result level change. See INT or S_RES question documentation. ';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TimeSlotUsageRange','define the range usage of the time slot in percentage. This will modified the end bound evalution in Callback of type TimeSlot-Increment ';
exec VX_DBDoc 'user.table.column','dbo.TimeSlot.TimeSlotRestrictionOverride','Override of global option: 0 Default (Udes Global Option), 1 Lift time slot restriction, 2 Drop Callback';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.TimeSlot.PK_TimeSlot','PK on [StrQuotaId] ASC,[StrRespondent] ASC';



--:------------------------------------------------------------------------
--: TimeSlotHit table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.TimeSlotHit','Contains all the time slots in which each case has been called';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.TimeSlotHit.TshRespondent','Case ID';
exec VX_DBDoc 'user.table.column','dbo.TimeSlotHit.TshTimeSlot',' Time Slot ID';
exec VX_DBDoc 'user.table.column','dbo.TimeSlotHit.Counter','Hit Counter';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.TimeSlotHit.PK_TimeSlotHit','PK on [TshRespondent] ASC,	[TshTimeSlot] ASC';
--exec VX_DBDoc 'User.Table.Constraint','dbo.TimeSlotHit.FK__TimeSlotH__TshRe__1920BF5C','FK';




--:------------------------------------------------------------------------
--: TimeSlotCounter table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.TimeSlotCounter','';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.TimeSlotCounter.TimeSlotCounterId','Time Slot Counter Id';
exec VX_DBDoc 'user.table.column','dbo.TimeSlotCounter.TslNumber','Time Slot number';
exec VX_DBDoc 'user.table.column','dbo.TimeSlotCounter.RespondentLevel','Case Level';
exec VX_DBDoc 'user.table.column','dbo.TimeSlotCounter.MaxCounter','Max counter';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.TimeSlotCounter.PK_TimeSlotCounter','PK on [TimeSlotCounterId] ASC';



--:------------------------------------------------------------------------
--:  RespondentPIN table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.RespondentPIN','A look up table to linking a respondent to his/her PIN';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.RespondentPIN.RspRespondent','Case Id';
exec VX_DBDoc 'user.table.column','dbo.RespondentPIN.RspPIN','Respondent PIN';
exec VX_DBDoc 'user.table.column','dbo.RespondentPIN.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.RespondentPIN.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.RespondentPIN.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.RespondentPIN.PK_RespondentPIN','PK on [RspRespondent] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.RespondentPIN.FK_RespondentPIN_Respondent','FK on [RspRespondent] on [dbo].[Respondent].[ResRespondent]';





--:------------------------------------------------------------------------
--:  MonitoringCfg table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.MonitoringCfg','Contains the Monitoring configuration parameters';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.NbrInterviewsToMonitor','Number of interviewers to monitor';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.MonitoringType','Monitoring type';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.NbrQuestionToCompletInterview','Number of questions to complete for an interview';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.MinSessionDuration','Minimum time in seconds for Session duration';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.MaxInterviewsPerDay','Maximum number of monitored interviews per day';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfg.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.MonitoringCfg.PK_MonitoringCfg','PK on [ProjectID] ASC';


--:------------------------------------------------------------------------
--:  MonitoringCfgQuestionsThatCount table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.MonitoringCfgQuestionsThatCount','Contains the list of questions to be monitored...(TODO see Thierry)  ';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfgQuestionsThatCount.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.MonitoringCfgQuestionsThatCount.QuestionAlias','Question Alias';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.MonitoringCfgQuestionsThatCount.PK_MonitoringCfgQuestionsThatCount','PK on [ProjectID] ASC, [QuestionAlias] ASC';




--:------------------------------------------------------------------------
--: BufferNew table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.BufferNew','Contains the respondents that will be called next';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.BufferNew.Respondent','Case Id  PrimaryKey';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.intgroup','Interviewer Group';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.ResCall','Respondent ResCall - 1 if the case has been called or is currently on the line, or has been selected by the servnoserver module DEFAULT=0';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.NEwDateTime','Time at which the case was buffered to be called. Used to determined when to recycle buffered cases (dflt 5min.) DEFAULT=GetUTCDate()';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.CallbackDate','copy of Respondent.rescallbackdate DEFAULT=-2';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.Priority','copy of Respondent.respriority DEFAULT=1';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.seed','copy of Respondent.resseed DEFAULT=Rand()';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.Phone','copy of Respondent.resphone';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.DialingMode','copy of Respondent.DialingMode DEFAULT=0';
exec VX_DBDoc 'user.table.column','dbo.BufferNew.OrderKey','The order in which the cases were buffered. Primary order for getting cases from the buffer.';
--KEYS & CONSTRAINTS
--exec VX_DBDoc 'User.Table.Constraint','dbo.BufferNew.PK__BufferNew__0AD2A005','PK on [Respondent] ASC';



--:------------------------------------------------------------------------
--: BufferTrace table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.BufferTrace','Contains traces of each case extractions done through VX_sp_FillCaseBuffer.';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.TraceId','Trace Id PrimaryKey. Is also returned by VX_sp_FillCaseBuffer in a way to uniquely identify each extractions.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.ApplicationName','Name of the calling application if set. See APP_NAME (Transact-SQL) documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.Info','Optional data that has been passed in by the application for tracing purpose only.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.StartDate','Date & time the extraction was started.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.EndDate','Date & time the extraction has completed.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.RequestedCases','SP Input parameter. See SP documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.DialingMask','SP Input parameter. See SP documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.ClearBuffer','SP Input parameter. See SP documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.GroupNbr','SP Input parameter. See SP documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.RoleSets','SP Input parameter. See SP documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.UseSmoothing','Project quota configuration. See CommandCenter documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.UseQuotas','Project quota configuration. See CommandCenter documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.Replicate','Project quota configuration. See CommandCenter documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.DNCFlag','Project DNC configuration. See CommandCenter documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.FreshPriority','Project quota configuration. See CommandCenter documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.WeightsCount','Count of project quotas with weight. See CommandCenter documentation.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.ExcludedCases','Count of cases excluded from selection because of closed stratum or timeslot restriction.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.HalfOpenExcess','Count of cases picked but returned to prevent exceeding a half open stratum quota.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.TotalExtractedCases','Final count of cases inserted in the BufferNew table.';
exec VX_DBDoc 'user.table.column','dbo.BufferTrace.ClientHostname','Name of the calling workstation if set. See HOST_NAME (Transact-SQL) documentation.';
--KEYS & CONSTRAINTS
--exec VX_DBDoc 'User.Table.Constraint','dbo.BufferTrace.PK_BufferTrace','PK on [BufferTrace] ASC';


--:------------------------------------------------------------------------
--: ExtendedRules table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.ExtendedRules','Contains the definition of extended callback rules';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtNumber','Extended rules index field replace with field Id';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtNewResult','New case code result,  An optional INT code, that replaces the Current Case Result code, if the rule applies.';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtLifeState',' Current Case Result. An optional INT code  (or a list of equivalent codes) indicating the Case Result that must exist for the rule to apply';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtResultsSequence','Results Code Sequence. A string of result codes  for the rule to apply.';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtCallback','determines whether the rule requires the case to be called back or not ';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtInterviewer','Interviewer Id';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtDelay','Delay of the callback';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtUnit','Delay type of the callback Minutes,Days,Shifts,Weekends, TimeSlots';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtPriority','Callback rule priority';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtPriorityType','Priority action Type';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.ExtWaveInc','Wave inc';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.modified','Date & Time modification of the record'
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.SynchResult','CAPI syncronization result action';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.DialingMode','Dialing mode';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.RestrictionOverride','';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.Deleted','For trace information';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.Id','ExtendedRules index replacing [ExtNumber] as Primary key (identity)';
exec VX_DBDoc 'user.table.column','dbo.ExtendedRules.UploadToA4S','Add rule to Acuity4 for Acuit4 modules'; 

--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.ExtendedRules.PK_ExtendedRules','PK on [Id] ASC';



--:------------------------------------------------------------------------
--: Role table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Role','Contains the role definition of the project';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Role.Id','Role Id';
exec VX_DBDoc 'user.table.column','dbo.Role.Name','Role Name';
exec VX_DBDoc 'user.table.column','dbo.Role.Category','Role Category';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Role.PK_Role','PK on [Id] ASC';


--:------------------------------------------------------------------------
--: RoleAssignment table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.RoleAssignment','Contains the Roles/ Interviewer assignement of the project';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.RoleAssignment.Id','Role Assignement ID';
exec VX_DBDoc 'user.table.column','dbo.RoleAssignment.k_Id','Interviewer Id';
exec VX_DBDoc 'user.table.column','dbo.RoleAssignment.RoleId','Role Id';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.RoleAssignment.PK_RoleAssignment','PK on [Id] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.RoleAssignment.FK_RoleAssignment_Role','FK [RoleId] to [dbo].[Role].[Id]';





--:------------------------------------------------------------------------
--:  RespondentState table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.RespondentState','Legacy. No longer used.';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.RespondentState.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.RespondentState.RespondentId','Case Id';
exec VX_DBDoc 'user.table.column','dbo.RespondentState.isBlocked','Is blocked flag';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.RespondentState.PK_Table1','PK on [projectId] ASC,[RespondentId] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.RespondentState.FK_RespondentState_Respondent','FK on [RespondentId] to [dbo].[Respondent].[ResRespondent]';




--:------------------------------------------------------------------------
--:  QuotasAgent table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.QuotasAgent','Contains specific Quota definitions for a given interviewer';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.Stratum','Stratum index';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.AgentId','Interviewer Id';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.Quota','Stratum goal';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.Sent','number of cases sent to the remote capi interviewer';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.Frequency','Completed surveys in the given stratum  DEFAULT=0';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.QuotaId','FK QuotaId reference to Quota table';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.QuotaStatus','Stratum status: 0 open, 1 half-open, 2 closed  DEFAULT=0';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.Unused','Unused cases in the given stratum  DEFAULT=0';
exec VX_DBDoc 'user.table.column','dbo.QuotasAgent.SyncLastTotalFreq','Total frequency of the last synchonization  DEFAULT=0';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.QuotasAgent.PK_QuotasAgent','PK on [QuotaId] ASC, [AgentId] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.QuotasAgent.FK_QuotasAgentAndQuota','FK on QuotaId to [dbo].[Quota].[QtQuotaId]';






--:------------------------------------------------------------------------
--:  CapiAgent table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CapiAgent','Contains the list of the active CAPI interviewers on the project. With their status.  ';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CapiAgent.AgentId','Interviewer Id';
exec VX_DBDoc 'user.table.column','dbo.CapiAgent.Status','CAPI Status of the interviewer';
exec VX_DBDoc 'user.table.column','dbo.CapiAgent.ModeCreate','Creation mode';
exec VX_DBDoc 'user.table.column','dbo.CapiAgent.ToSend','Number of cases to send to the interviewer';
exec VX_DBDoc 'user.table.column','dbo.CapiAgent.LastAccess','Last access date & time';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CapiAgent.PK_CapiAgent','PK on [AgentId] ASC';





--:------------------------------------------------------------------------
--:  CAPIResultCodeActions table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CAPIResultCodeActions','Contains the list of actions per resultcode that the system has to do upon CAPI synchronization';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CAPIResultCodeActions.INTCode','Result code';
exec VX_DBDoc 'user.table.column','dbo.CAPIResultCodeActions.ActionID','Action Id';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CAPIResultCodeActions.PK_CAPIResultCodeActions','PK on [INTCode] ASC, 	[ActionID] ASC';




--:------------------------------------------------------------------------
--:  CAMI_Synchronization table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CAMI_Synchronization','Contains the Cami Synchronization logs';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.entryId','Id';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.syncId','Synchonization Id';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.description','Synchonization Step description';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.systemMessage','Error message if any';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.entryDate','Date & time of the log entry';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.syncDate','Synchronization';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.syncOwnerId','UserId of the person responsible fot the synchronization ';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Synchronization.moduleId','Id of the module';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CAMI_Synchronization.PK_CamiSyncronisation','PK on [entryId] ASC';



--:------------------------------------------------------------------------
--:  table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CAMI_Assignation','Contains CAMI interveiwer assignation and synchronization status';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CAMI_Assignation.assignationId','Id';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Assignation.userType','User Type';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Assignation.userId','Interviwer Id';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Assignation.syncStatus','Status of the last synchronization';
exec VX_DBDoc 'user.table.column','dbo.CAMI_Assignation.moduleId','Module Id';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CAMI_Assignation.PK_CamiAssignation','PK on [assignationId] ASC';




--:------------------------------------------------------------------------
--:  ResponseModifLog table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.ResponseModifLog','Contains audit log of modifications to the respondent responses'
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Id','Entry ID';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Respondent','Case Id';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Question','Modified question alias';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Matrix','Roster row index. (Ex. 12000250000400217 => nested row 12-25-4-217)';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Mention','Response index';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Content','The new content value';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.OldContent','The previous content value';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.OpenEnd','The new open-ended value';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.OldOpenEnd','The previous open-ended value';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Source','Source of the modification ( application name)';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.Comment','Optional change comment';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.modified','Date & Time modification of the record'
exec VX_DBDoc 'user.table.column','dbo.ResponseModifLog.CallId','CallId of the modification - relation to the Historic CallId if not 0'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.ResponseModifLog.PK_ResponseModifLog','PK on [Id] ASC';



--:------------------------------------------------------------------------
--:  RespondentModifLog table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.RespondentModifLog','Contains audit log of modifications to the Respondent table';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.Id','entry ID';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.Respondent','Respondent Id';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.Action','action type, update,insert delete';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.FieldName','modified fieldname';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.FieldValue','new value of the modified field';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.OldFieldValue','old value of the modified field';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.Source','source of the modification ( application name)';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.Comment','optional change comment';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.RespondentModifLog.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.RespondentModifLog.PK_RespondentModifLog','PK on [Id] ASC';





--:------------------------------------------------------------------------
--:  VoxcoDBVersion table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.VoxcoDBVersion','Contains version and System updated versions date';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.VoxcoDBVersion.Version','Version number of the upgrade';
exec VX_DBDoc 'user.table.column','dbo.VoxcoDBVersion.UpgradeDate','Date & time of the upgrade';
exec VX_DBDoc 'user.table.column','dbo.VoxcoDBVersion.Comment','Upgrade comment';
exec VX_DBDoc 'user.table.column','dbo.VoxcoDBVersion.VersionId','Version Id';

--:------------------------------------------------------------------------
--:  CAPI_CasesToSendBack table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CAPI_CasesToSendBack','Contains all the cases that an interviewer must send back to server. This table is only used on the local machine of the CAPI interviewer';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CAPI_CasesToSendBack.Respondent','Case Id';
exec VX_DBDoc 'user.table.column','dbo.CAPI_CasesToSendBack.Interviewer','Interviewer Id';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CAPI_CasesToSendBack.PK_CAPI_CasesToSendBack','PK on [Respondent] ASC';



--:------------------------------------------------------------------------
--: CaseAccessRestriction table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CaseAccessRestriction','Contains all users restrictions definitions.They specify which cases a specific user can see in browse and in CB assignement';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.CaseAccessRestrictionId','Unique Id of the restriction';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.UserId','UserId. on which the case restriction will be applying';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.Criterion','strata expression of the case restriction';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.Comment','comment of the case restriction';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.Enabled','case restriction enabled or not';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.projectId','Project Id';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.CaseAccessRestriction.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CaseAccessRestriction.PK_CaseAccessRestrictionId','PK on [CaseAccessRestrictionId] ASC';


--:------------------------------------------------------------------------
--:  Appearance table
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.Appearance','Contains all the Appearances for a specific module, that will be used by intweb, this table will bypass directoryserver in order to support unicode';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.Appearance.ModuleId','Collection Module ID on the appearence settings will apply';
exec VX_DBDoc 'user.table.column','dbo.Appearance.PropertyName','The name of the appearence property';
exec VX_DBDoc 'user.table.column','dbo.Appearance.PropertyValue','The value of the appearence property';
exec VX_DBDoc 'user.table.column','dbo.Appearance.modifiedBy','UserId. of the last user that modified the record';
exec VX_DBDoc 'user.table.column','dbo.Appearance.modified','Date & Time Modification of the record';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.Appearance.PK_Appearance','PK on [ModuleId] [PropertyName]';


--:------------------------------------------------------------------------
--:  HistoricResponse table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.HistoricResponse','Contains audit log of modifications to the respondent responses. It is the historical values per call for each question responses.  This table is filled only whene the option is enabled in Command Center.  By default this option is disabled because of the SQL load that option can generate. '
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.Id','Unique Id of the Response History entry';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.Respondent','Case Id';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.CallId','CallId of the modification - relation to the Historic HisCallNumber'
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.Question','Modified question alias';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.Matrix','Roster row index. (Ex. 12000250000400217 => nested row 12-25-4-217)';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.Mention','Response index';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.Content','The new content value';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.OpenEnd','The new open-ended value';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.modifiedBy','UserId. Who modified the record';
exec VX_DBDoc 'user.table.column','dbo.HistoricResponse.modified','Date & Time modification of the record'
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.HistoricResponse.PK_HistoricResponse','PK on [Id] ASC';


--:------------------------------------------------------------------------
--:  ResetDataHistory table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.ResetDataHistory','Contains audit log of the last Data History reset. '
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.ResetDataHistory.Id','Unique Id of the reset';
exec VX_DBDoc 'user.table.column','dbo.ResetDataHistory.Description','A description/comment of the reset';
exec VX_DBDoc 'user.table.column','dbo.ResetDataHistory.ResetDate','Data reset date'

--:------------------------------------------------------------------------
--: CaseActionHistory table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CaseActionHistory','Contains actions on Cases (Importation and Callback Assignment)';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.ActionId','Action Index';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.ActionType','Action Type (Import, CBAssignment)';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.DataSource','importation file name, nothing if Callback Assignment';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.CaseCount','Number of cases touched by action';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.FilterDefinition','XML of the filter definition';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.Description','Description of Action details applied to Cases';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.Modified','Date time of action';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistory.modifiedBy','UserId. Who modified the record';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CaseActionHistory.PK_CaseActionHistory','PK on [ActionId] ASC';

--:------------------------------------------------------------------------
--: CaseActionHistoryDetail table details
--:------------------------------------------------------------------------
--TABLE
exec VX_DBDoc 'user.table','dbo.CaseActionHistoryDetail','Contains action detail on respondent (importation and Callback Assignment)';
--COLUMNS
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistoryDetail.ActionDetailId','Action Detail Index';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistoryDetail.ActionId','Action Index';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistoryDetail.ActionDetailType','Action Detail Type (Import, CBAssigned)';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistoryDetail.CaseId','CaseId';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistoryDetail.Modified','Date of Action';
exec VX_DBDoc 'user.table.column','dbo.CaseActionHistoryDetail.modifiedBy','UserId. Who modified the record';
--KEYS & CONSTRAINTS
exec VX_DBDoc 'User.Table.Constraint','dbo.CaseActionHistoryDetail.PK_CaseActionHistoryDetail','PK on [ActionDetailId] ASC';
exec VX_DBDoc 'User.Table.Constraint','dbo.CaseActionHistoryDetail.FK_CaseActionHistoryDetail_CaseActionHistory','FK on dbo.CaseActionHistory.[ActionId]';
